/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.ResultValuesUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationMessage;
import oracle.cluster.verification.pluggable.ExecutableInfo;
import oracle.cluster.verification.pluggable.ExecutableResultType;
import oracle.cluster.verification.pluggable.InitialValidation;
import oracle.cluster.verification.pluggable.PluggableMsgType;
import oracle.cluster.verification.pluggable.PluggableTaskUtil;
import oracle.cluster.verification.pluggable.ResultAnalyzerException;
import oracle.cluster.verification.pluggable.VerificationExecutableException;
import oracle.cluster.verification.pluggable.task.PluggableTaskContext;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class PluggableTask
extends Task {
    protected static MessageBundle s_plgMsgBundle = VerificationUtil.getMessageBundle("Prve");
    private PluggableTaskUtil m_plgUtil = null;
    List<InitialValidation> m_initValidation;
    protected PluggableTaskContext m_ctx;
    protected boolean m_silent;

    public PluggableTask(PluggableTaskContext ctx) {
        super(ctx.getNodeList(), ctx.getTaskID());
        this.m_ctx = ctx;
        this.m_bestPractice = true;
        this.m_plgUtil = this.m_ctx.isDarwin() ? PluggableTaskUtil.createPluggableTaskUtil(ctx.isDarwin()) : new PluggableTaskUtil();
    }

    public void setInitialValidation(List<InitialValidation> initValidation) {
        this.m_initValidation = initValidation;
    }

    public ExecutableInfo getExecutableInfo() {
        return this.m_ctx.getExecInfo();
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing pluggable task... ");
        this.printTaskBeginHeader();
        this.performPluggableTaskExecution();
        this.analyzeAndDisplayResults();
        return this.m_resultSet.allSuccess();
    }

    protected void printTaskBeginHeader() {
        if (!this.m_silent) {
            ReportUtil.sureprintln(LSEP + s_plgMsgBundle.getMessage("0001", false, (Object[])new String[]{this.getElementName()}));
        }
    }

    protected void analyzeAndDisplayResults() {
        Hashtable t = this.m_resultSet.getResultTable();
        Enumeration e = t.keys();
        if (this.m_resultSet.getStatus() == 4) {
            if (!this.m_silent) {
                ReportUtil.printWarning("");
            }
        } else if (!(this.m_resultSet.getStatus() != 2 && this.m_resultSet.getStatus() != 3 || this.m_silent)) {
            ReportUtil.printError("");
        }
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            String actualValue = null;
            String expectedValue = null;
            if (result.hasResultValues()) {
                try {
                    actualValue = result.getActualValue();
                }
                catch (ResultValuesUnavailableException e1) {
                    // empty catch block
                }
                try {
                    expectedValue = result.getExpectedValue();
                }
                catch (ResultValuesUnavailableException e1) {
                    // empty catch block
                }
            }
            CollectionElement collection = new CollectionElement(this.getDefaultElementName(), actualValue, expectedValue, null, this.getDefaultDescription(), result.getStatus());
            if (VerificationUtil.isStringGood(actualValue) || VerificationUtil.isStringGood(expectedValue)) {
                result.addCollectionElement(collection);
            }
            List<VerificationError> errList = result.getErrors();
            for (int i = 0; i < errList.size(); ++i) {
                ErrorDescription errDesc = (ErrorDescription)errList.get(i);
                collection.addErrorDescription(errDesc);
                if (this.m_silent) continue;
                ReportUtil.sureprintln(errDesc.getErrorMessage());
            }
            List<VerificationMessage> msgList = result.getVerificationMessage();
            if (!this.m_silent) {
                for (int i = 0; i < msgList.size(); ++i) {
                    VerificationMessage msg = msgList.get(i);
                    ReportUtil.println(msg.getMessage());
                }
            }
            Vector traceInfo = result.getTraceInfoSet();
            for (int i = 0; i < traceInfo.size(); ++i) {
                String traceMsg = (String)traceInfo.elementAt(i);
                Trace.out((String)(traceMsg + LSEP));
            }
            Vector errInfo = result.getErrorInfoSet();
            for (int i = 0; i < errInfo.size(); ++i) {
                String errorMsg = (String)errInfo.elementAt(i);
                Trace.out((String)(errorMsg + LSEP));
            }
        }
        List<VerificationError> errList = this.m_resultSet.getErrors();
        if (!this.m_silent) {
            for (int i = 0; i < errList.size(); ++i) {
                ErrorDescription errDesc = (ErrorDescription)errList.get(i);
                ReportUtil.sureprintln(errDesc.getErrorMessage());
            }
        }
        List<VerificationMessage> msgList = this.m_resultSet.getVerificationMessages();
        if (!this.m_silent) {
            for (int i = 0; i < msgList.size(); ++i) {
                VerificationMessage msg = msgList.get(i);
                ReportUtil.println(msg.getMessage());
            }
        }
        if (!this.m_silent) {
            if (this.m_resultSet.allSuccess()) {
                ReportUtil.sureprintln(LSEP + s_plgMsgBundle.getMessage("0002", false, (Object[])new String[]{this.getElementName()}));
                this.m_resultSet.setResultSummary(s_plgMsgBundle.getMessage("0002", false, (Object[])new String[]{this.getElementName()}));
            } else {
                ReportUtil.sureprintln(LSEP + s_plgMsgBundle.getMessage("0003", false, (Object[])new String[]{this.getElementName()}));
                this.m_resultSet.setResultSummary(s_plgMsgBundle.getMessage("0003", false, (Object[])new String[]{this.getElementName(), VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
            }
        }
    }

    @Override
    public String getTaskID() {
        return this.m_ctx.getTaskID();
    }

    private void performPluggableTaskExecution() {
        String[] validNodeArr;
        if (this.m_initValidation != null && this.m_initValidation.size() > 0) {
            ResultSet initValRset = this.performInitialValidations(this.m_nodeList, this.m_initValidation);
            Trace.out((String)"\n>>>> PluggableTask:: Upload initValRset >>>>\n");
            this.m_resultSet.uploadResultSet(initValRset);
            validNodeArr = initValRset.getSuccNodes();
            if (validNodeArr == null || validNodeArr.length == 0) {
                return;
            }
        } else {
            validNodeArr = this.m_nodeList;
        }
        try {
            ResultSet verExecRset = this.m_plgUtil.execVerificationExecutable(validNodeArr, this.m_ctx.getExecInfo());
            if (this.m_ctx.getExecInfo().getResultType() == ExecutableResultType.ANALYZED) {
                Trace.out((String)"\n>>>> PluggableTask:: Upload verExecRset(Self-Analyzing) >>>>\n");
                this.m_resultSet.uploadResultSet(verExecRset);
                return;
            }
            if (!verExecRset.anySuccess()) {
                Trace.out((String)"\n>>>> PluggableTask:: Upload verExecRset(Information-fetching) >>>>\n");
                this.m_resultSet.uploadResultSet(verExecRset);
                return;
            }
            ResultSet analyzerRset = this.m_ctx.getExecInfo().getDataComparator().analyzeResult(verExecRset);
            Trace.out((String)"\n>>>> PluggableTask:: Upload analyzerRset >>>>\n");
            this.m_resultSet.uploadResultSet(analyzerRset);
            return;
        }
        catch (VerificationExecutableException ve) {
            ReportUtil.sureprintln(s_plgMsgBundle.getMessage("0012", true) + LSEP + ve.getMessage());
            this.m_resultSet.addResult(validNodeArr, 2);
            return;
        }
        catch (ResultAnalyzerException re) {
            ReportUtil.sureprintln(s_plgMsgBundle.getMessage("0013", true) + LSEP + re.getMessage());
            this.m_resultSet.addResult(validNodeArr, 2);
            return;
        }
    }

    public ResultSet performInitialValidations(String[] nodeList, List<InitialValidation> validationList) {
        ResultSet validationRS = new ResultSet();
        for (InitialValidation validation : validationList) {
            this.performInitialValidation(nodeList, validation, validationRS);
        }
        return validationRS;
    }

    private void performInitialValidation(String[] nodeList, InitialValidation validation, ResultSet validationRS) {
        switch (validation) {
            case CRS_INSTALL: {
                String[] validNodeArr = VerificationUtil.getNodesWithCRSInstall(nodeList, validationRS);
                if (validNodeArr != null) break;
                validationRS.addResult(nodeList, 2);
                return;
            }
        }
    }

    public boolean isSilent() {
        return this.m_silent;
    }

    public void setSilent(boolean silent) {
        this.m_silent = silent;
    }

    @Override
    public String getDefaultElementName() {
        return this.m_plgUtil.getPluggableMsg(PluggableMsgType.TASK_ELEMENT_NAME, this.m_ctx.getTaskID(), this.m_ctx.getIdMsgParams());
    }

    @Override
    public String getDefaultDescription() {
        return this.m_plgUtil.getPluggableMsg(PluggableMsgType.TASK_DESCRIPTION, this.m_ctx.getTaskID(), this.m_ctx.getIdMsgParams());
    }

    public void setBestPractice(boolean bestPractice) {
        this.m_bestPractice = bestPractice;
    }

    public String[] getIdMsgParams() {
        return this.m_ctx.getIdMsgParams();
    }

    public void setExecutableInfo(ExecutableInfo execInfo) {
        this.m_ctx.setExecutableInfo(execInfo);
    }

    public void setIdMsgParams(String[] idMsgparam) {
        this.m_ctx.setIdMsgParams(idMsgparam);
    }
}

